/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.VSMXCode;
import jpcsp.format.rco.vsmx.VSMXGroup;
import jpcsp.format.rco.vsmx.VSMXMem;
import org.apache.log4j.Logger;

public class VSMXDecompiler {
    private static Logger log = VSMX.log;
    private VSMXMem mem;
    private String prefix;
    private Stack<Integer> blockEnd;
    private Stack<Integer> stack;
    private static final int SWITCH_STATE_NONE = 0;
    private static final int SWITCH_STATE_START = 1;
    private static final int SWITCH_STATE_VALUE = 2;
    private static final int SWITCH_STATE_CASE = 3;
    private static final int SWITCH_STATE_MULTI_VALUE = 4;
    private int switchState;
    private int switchBreakLine;
    private int ignoreFunctionSet;
    private int statementStartLine;
    private Set<Integer> needLineLabel;
    private StringBuilder booleanExpression;

    public VSMXDecompiler(VSMX vsmx) {
        this.mem = vsmx.getMem();
    }

    private void increaseIndent(int blockEndLine) {
        this.prefix = this.prefix + "  ";
        this.blockEnd.push(blockEndLine);
    }

    private void decrementIndent() {
        this.blockEnd.pop();
        this.prefix = this.prefix.substring(0, this.prefix.length() - 2);
    }

    private void operator2(StringBuilder s, String operator) {
        StringBuilder op1 = new StringBuilder();
        StringBuilder op2 = new StringBuilder();
        this.decompileOp(op1);
        this.decompileOp(op2);
        s.append(String.format("%s%s%s", op2, operator, op1));
    }

    private void operatorPre1(StringBuilder s, String operator) {
        StringBuilder op = new StringBuilder();
        this.decompileOp(op);
        s.append(String.format("%s%s", operator, op));
    }

    private void operatorPost1(StringBuilder s, String operator) {
        StringBuilder op = new StringBuilder();
        this.decompileOp(op);
        s.append(String.format("%s%s", op, operator));
    }

    private boolean isBooleanExpression(StringBuilder s) {
        if (this.stack.isEmpty()) {
            return false;
        }
        int i = this.stack.peek();
        if (!this.mem.codes[i].isOpcode(32)) {
            return false;
        }
        this.stack.pop();
        this.decompileOp(s);
        return true;
    }

    private void addToBooleanExpression(StringBuilder s) {
        if (this.booleanExpression == null) {
            this.booleanExpression = new StringBuilder();
        }
        this.booleanExpression.append(s.toString());
    }

    private void addToBooleanExpression(StringBuilder s, boolean isOr) {
        this.addToBooleanExpression(s);
        this.booleanExpression.append(isOr ? " || " : " && ");
    }

    private void decompileStmt(StringBuilder s) {
        if (this.stack.isEmpty()) {
            return;
        }
        int i = this.stack.pop();
        this.decompileStmt(s, i);
    }

    private boolean detectSwitch(StringBuilder s, int i) {
        if (this.mem.codes[i + 1].isOpcode(71)) {
            ++i;
        }
        if (!this.mem.codes[i + 1].isOpcode(57)) {
            return false;
        }
        return this.blockEnd.size() <= 0 || this.blockEnd.peek() != i;
    }

    private boolean isSwitch(int jumpLine) {
        if (this.switchState == 0) {
            return false;
        }
        return this.switchState != 3 || this.switchBreakLine < 0 || jumpLine == this.switchBreakLine;
    }

    private int decompileSwitch(StringBuilder s, int i, int jumpLine) {
        switch (this.switchState) {
            case 0: {
                StringBuilder op = new StringBuilder();
                this.decompileOp(op);
                s.append(String.format("%sswitch (%s) {\n", this.prefix, op));
                this.switchState = 1;
                this.switchBreakLine = -1;
                break;
            }
            case 1: {
                if (this.switchBreakLine >= 0 && jumpLine == this.switchBreakLine) {
                    this.switchState = 0;
                    i = this.switchBreakLine - 1;
                    break;
                }
                this.switchState = 2;
                break;
            }
            case 2: {
                StringBuilder op = new StringBuilder();
                this.decompileOp(op);
                if (this.mem.codes[i + 1].isOpcode(71)) {
                    ++i;
                }
                if (this.mem.codes[i + 1].isOpcode(57)) {
                    s.append(String.format("%scase %s:\n", this.prefix, op));
                    this.switchState = 4;
                    break;
                }
                s.append(String.format("%scase %s: {\n", this.prefix, op));
                this.switchState = 3;
                this.increaseIndent(0);
                break;
            }
            case 4: {
                this.switchState = 2;
                break;
            }
            case 3: {
                s.append(String.format("%sbreak;\n", this.prefix));
                this.decrementIndent();
                s.append(String.format("%s}\n", this.prefix));
                this.switchBreakLine = jumpLine;
                this.switchState = 1;
            }
        }
        return i;
    }

    private boolean isFunction(int i) {
        if (this.stack.isEmpty()) {
            return false;
        }
        int prev = this.stack.peek();
        VSMXGroup prevCode = this.mem.codes[prev];
        if (prevCode.isOpcode(1)) {
            prevCode = this.mem.codes[--prev];
        }
        if (!prevCode.isOpcode(42) || prevCode.value != i + 1) {
            return false;
        }
        VSMXGroup prePrevCode = this.mem.codes[prev - 1];
        if (prePrevCode.isOpcode(47)) {
            prePrevCode = this.mem.codes[--prev - 1];
        }
        return prePrevCode.isOpcode(46);
    }

    private void decompileFunction(StringBuilder s, int setLine) {
        StringBuilder function = new StringBuilder();
        this.decompileOp(function);
        StringBuilder name = new StringBuilder();
        this.decompileOp(name);
        this.stack.push(setLine);
        StringBuilder set = new StringBuilder();
        this.decompileOp(set);
        s.append(String.format("%s%s.%s = %s\n", this.prefix, name, set, function));
        this.increaseIndent(setLine);
        this.ignoreFunctionSet = setLine;
    }

    private void decompileOp(StringBuilder s) {
        if (this.stack.isEmpty()) {
            return;
        }
        int i = this.stack.pop();
        VSMXGroup code = this.mem.codes[i];
        int opcode = code.getOpcode();
        switch (opcode) {
            case 46: {
                s.append(this.mem.names[code.value]);
                break;
            }
            case 45: {
                s.append(String.format("var%d", code.value));
                break;
            }
            case 37: {
                if (code.value == 1) {
                    s.append("true");
                    break;
                }
                if (code.value == 0) {
                    s.append("false");
                    break;
                }
                s.append(String.format("0x%X", code.value));
                break;
            }
            case 38: {
                s.append(String.format("%d", code.value));
                break;
            }
            case 39: {
                s.append(String.format("%f", Float.valueOf(code.getFloatValue())));
                break;
            }
            case 40: 
            case 70: {
                s.append(String.format("\"%s\"", this.mem.texts[code.value]));
                break;
            }
            case 47: {
                StringBuilder op = new StringBuilder();
                this.decompileOp(op);
                s.append(String.format("%s.%s", op, this.mem.properties[code.value]));
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                s.append(this.mem.properties[code.value]);
                break;
            }
            case 42: {
                int args = code.id >> 8 & 0xFF;
                s.append("function(");
                for (int n = 0; n < args; ++n) {
                    if (n > 0) {
                        s.append(", ");
                    }
                    s.append(String.format("var%d", n + 1));
                }
                s.append(String.format(") {", new Object[0]));
                break;
            }
            case 36: {
                s.append("{}");
                break;
            }
            case 35: {
                s.append("null");
                break;
            }
            case 44: {
                s.append("this");
                break;
            }
            case 52: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                s.append(String.format("%s[%s]", op2, op1));
                break;
            }
            case 53: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                i = this.stack.peek();
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                this.stack.push(i);
                s.append(String.format("%s[%s]", op2, op1));
                break;
            }
            case 62: {
                int n;
                int args = code.value;
                StringBuilder[] ops = new StringBuilder[args];
                for (n = args - 1; n >= 0; --n) {
                    ops[n] = new StringBuilder();
                    this.decompileOp(ops[n]);
                }
                StringBuilder op = new StringBuilder();
                this.decompileOp(op);
                s.append(String.format("new %s(", op));
                for (n = 0; n < args; ++n) {
                    if (n > 0) {
                        s.append(", ");
                    }
                    s.append((CharSequence)ops[n]);
                }
                s.append(")");
                break;
            }
            case 61: {
                int n;
                int args = code.value;
                StringBuilder[] ops = new StringBuilder[args];
                for (n = args - 1; n >= 0; --n) {
                    ops[n] = new StringBuilder();
                    this.decompileOp(ops[n]);
                }
                StringBuilder method = new StringBuilder();
                this.decompileOp(method);
                StringBuilder op = new StringBuilder();
                this.decompileOp(op);
                s.append(String.format("%s.%s(", op, method));
                for (n = 0; n < args; ++n) {
                    if (n > 0) {
                        s.append(", ");
                    }
                    s.append((CharSequence)ops[n]);
                }
                s.append(")");
                break;
            }
            case 60: {
                int n;
                int args = code.value;
                StringBuilder[] ops = new StringBuilder[args];
                for (n = args - 1; n >= 0; --n) {
                    ops[n] = new StringBuilder();
                    this.decompileOp(ops[n]);
                }
                StringBuilder method = new StringBuilder();
                this.decompileOp(method);
                s.append(String.format("%s(", method));
                for (n = 0; n < args; ++n) {
                    if (n > 0) {
                        s.append(", ");
                    }
                    s.append((CharSequence)ops[n]);
                }
                s.append(")");
                break;
            }
            case 14: {
                this.operator2(s, " == ");
                break;
            }
            case 15: {
                this.operator2(s, " != ");
                break;
            }
            case 21: {
                this.operator2(s, " > ");
                break;
            }
            case 20: {
                this.operator2(s, " >= ");
                break;
            }
            case 18: {
                this.operator2(s, " < ");
                break;
            }
            case 19: {
                this.operator2(s, " <= ");
                break;
            }
            case 9: {
                this.operatorPre1(s, "!");
                break;
            }
            case 8: {
                this.operatorPre1(s, "-");
                break;
            }
            case 2: {
                this.operator2(s, " + ");
                break;
            }
            case 3: {
                this.operator2(s, " - ");
                break;
            }
            case 4: {
                this.operator2(s, " * ");
                break;
            }
            case 5: {
                this.operator2(s, " / ");
                break;
            }
            case 6: {
                this.operator2(s, " % ");
                break;
            }
            case 25: {
                this.operator2(s, " & ");
                break;
            }
            case 26: {
                this.operator2(s, " ^ ");
                break;
            }
            case 27: {
                this.operator2(s, " | ");
                break;
            }
            case 28: {
                this.operatorPre1(s, "~");
                break;
            }
            case 29: {
                this.operator2(s, " << ");
                break;
            }
            case 30: {
                this.operator2(s, " >> ");
                break;
            }
            case 31: {
                this.operator2(s, " >>> ");
                break;
            }
            case 12: {
                this.operatorPost1(s, "++");
                break;
            }
            case 13: {
                this.operatorPost1(s, "--");
                break;
            }
            case 10: {
                this.operatorPre1(s, "++");
                break;
            }
            case 11: {
                this.operatorPre1(s, "--");
                break;
            }
            case 56: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                if (!this.stack.isEmpty() && this.mem.codes[this.stack.peek()].isOpcode(56)) {
                    StringBuilder op2;
                    while (!this.stack.isEmpty() && this.mem.codes[this.stack.peek()].isOpcode(56)) {
                        this.stack.pop();
                        op2 = new StringBuilder();
                        this.decompileOp(op2);
                        op1.insert(0, String.format(",\n%s  ", this.prefix));
                        op1.insert(0, op2.toString());
                    }
                    op2 = new StringBuilder();
                    this.decompileOp(op2);
                    s.append(String.format("%s {\n%s  %s\n%s}", op2, this.prefix, op1, this.prefix));
                    break;
                }
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                s.append(String.format("%s.push(%s)", op2, op1));
                break;
            }
            case 43: {
                s.append("new Array()");
                break;
            }
            case 1: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                s.append(String.format("%s = %s", op2, op1));
                break;
            }
            case 32: {
                if (this.stack.isEmpty()) break;
                i = this.stack.pop();
                this.stack.push(i);
                this.stack.push(i);
                this.decompileOp(s);
                break;
            }
            case 71: {
                this.decompileOp(s);
                break;
            }
            default: {
                log.warn((Object)String.format("Line #%d: decompileOp(%s) unimplemented", i, VSMXCode.VsmxDecOps[opcode]));
            }
        }
    }

    private int decompileStmt(StringBuilder s, int i) {
        int initialLength = s.length();
        VSMXGroup code = this.mem.codes[i];
        int opcode = code.getOpcode();
        switch (opcode) {
            case 1: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                s.append(String.format("%s%s = %s", this.prefix, op2, op1));
                break;
            }
            case 54: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                StringBuilder op3 = new StringBuilder();
                this.decompileOp(op3);
                s.append(String.format("%s%s[%s] = %s", this.prefix, op3, op2, op1));
                break;
            }
            case 60: 
            case 61: {
                this.stack.push(i);
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                s.append(String.format("%s%s", this.prefix, op1));
                break;
            }
            case 58: {
                StringBuilder op1 = new StringBuilder();
                if (this.isBooleanExpression(op1)) {
                    this.addToBooleanExpression(op1, true);
                    break;
                }
                if (this.booleanExpression != null) {
                    this.decompileOp(op1);
                    this.addToBooleanExpression(op1, true);
                    s.append(String.format("%sif (%s) {", this.prefix, this.booleanExpression));
                    this.increaseIndent(code.value);
                    this.booleanExpression = null;
                    break;
                }
                this.decompileOp(op1);
                s.append(String.format("%d:\n", this.statementStartLine));
                if (this.mem.codes[i + 1].isOpcode(57)) {
                    int elseGoto = this.mem.codes[i + 1].value;
                    s.append(String.format("%sif (%s) goto %d; else goto %d", this.prefix, op1, code.value, elseGoto));
                    this.needLineLabel.add(elseGoto);
                    this.needLineLabel.add(i + 2);
                    ++i;
                } else {
                    s.append(String.format("%sif (%s) goto %d", this.prefix, op1, code.value));
                }
                this.needLineLabel.add(code.value);
                break;
            }
            case 59: {
                StringBuilder op1 = new StringBuilder();
                if (this.isBooleanExpression(op1)) {
                    this.addToBooleanExpression(op1, false);
                    break;
                }
                if (this.booleanExpression != null) {
                    this.decompileOp(op1);
                    this.addToBooleanExpression(op1);
                    s.append(String.format("%sif (%s) {", this.prefix, this.booleanExpression));
                    this.increaseIndent(code.value);
                    this.booleanExpression = null;
                    break;
                }
                this.decompileOp(op1);
                s.append(String.format("%sif (%s) {", this.prefix, op1));
                this.increaseIndent(code.value);
                break;
            }
            case 63: {
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                s.append(String.format("%sreturn %s", this.prefix, op1));
                break;
            }
            case 49: {
                if (i == this.ignoreFunctionSet) {
                    this.ignoreFunctionSet = -1;
                    break;
                }
                StringBuilder op1 = new StringBuilder();
                this.decompileOp(op1);
                StringBuilder op2 = new StringBuilder();
                this.decompileOp(op2);
                s.append(String.format("%s%s.%s = %s", this.prefix, op2, this.mem.properties[code.value], op1));
                break;
            }
            case 12: {
                s.append(this.prefix);
                this.operatorPost1(s, "++");
                break;
            }
            case 13: {
                s.append(this.prefix);
                this.operatorPost1(s, "--");
                break;
            }
            case 10: {
                s.append(this.prefix);
                this.operatorPre1(s, "++");
                break;
            }
            case 11: {
                s.append(this.prefix);
                this.operatorPre1(s, "--");
                break;
            }
            case 14: {
                this.operator2(s, " == ");
                break;
            }
            case 57: {
                if (code.value > i) {
                    this.increaseIndent(code.value);
                    break;
                }
                s.append(String.format("%sgoto %d", this.prefix, code.value));
                break;
            }
            case 46: {
                s.append(this.prefix);
                s.append(this.mem.names[code.value]);
                break;
            }
            case 45: {
                s.append(this.prefix);
                s.append(String.format("var%d", code.value));
                break;
            }
            case 71: {
                break;
            }
            default: {
                log.warn((Object)String.format("Line #%d: decompileStmt(%s) unimplemented", i, VSMXCode.VsmxDecOps[opcode]));
            }
        }
        if (s.length() != initialLength) {
            if (s.charAt(s.length() - 1) != '{') {
                s.append(";");
            }
            s.append(String.format(" // line %d", i));
            s.append("\n");
        }
        return i;
    }

    private String decompile() {
        StringBuilder s = new StringBuilder();
        this.prefix = "";
        this.stack = new Stack();
        this.blockEnd = new Stack();
        this.switchState = 0;
        this.ignoreFunctionSet = -1;
        this.statementStartLine = 0;
        this.needLineLabel = new HashSet<Integer>();
        block5: for (int i = 0; i < this.mem.codes.length; ++i) {
            VSMXGroup code = this.mem.codes[i];
            int opcode = code.getOpcode();
            while (!this.blockEnd.isEmpty() && this.blockEnd.peek() == i) {
                this.decrementIndent();
                s.append(String.format("%s}\n", this.prefix));
            }
            if (this.needLineLabel.remove(i)) {
                s.append(String.format("%d:\n", i));
            }
            switch (opcode) {
                case 34: {
                    this.decompileStmt(s);
                    this.statementStartLine = i + 1;
                    continue block5;
                }
                case 58: 
                case 59: 
                case 63: {
                    i = this.decompileStmt(s, i);
                    continue block5;
                }
                case 57: {
                    if (this.isSwitch(code.value) || this.detectSwitch(s, i)) {
                        i = this.decompileSwitch(s, i, code.value);
                        continue block5;
                    }
                    if (this.isFunction(i)) {
                        this.decompileFunction(s, code.value);
                        continue block5;
                    }
                    if (!this.blockEnd.isEmpty() && this.blockEnd.peek() == i + 1) {
                        this.decrementIndent();
                        s.append(String.format("%s} else {\n", this.prefix));
                    }
                    i = this.decompileStmt(s, i);
                    continue block5;
                }
                default: {
                    this.stack.push(i);
                }
            }
        }
        return s.toString();
    }

    public String toString() {
        return this.decompile();
    }
}

